/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!********************************************************!*\
  !*** ./resources/js/design_1/parts/cookie_security.js ***!
  \********************************************************/
(function ($) {
  "use strict";

  $(document).ready(function () {
    $('.js-cookie-security-dialog-box').fadeIn(900);
    //$('.cu').fadeOut(900);
  });

  function handleStoreCookieSecurity($this, action, data) {
    $this.addClass('loadingbar').prop('disabled', true);
    $.post(action, data, function (result) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      if (result && result.code === 200) {
        showToast("success", result.title, result.msg);
        $('.js-cookie-security-dialog-box').remove();
        Swal.close();
      }
    }).fail(function (err) {
      $this.removeClass('loadingbar').prop('disabled', false);
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  }
  $('body').on('click', '.js-accept-all-cookies', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = '/cookie-security/all';
    var data = {};
    handleStoreCookieSecurity($this, action, data);
  });
  $('body').on('click', '.js-store-customize-cookies', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $('.js-cookie-form-customize-inputs');
    var action = '/cookie-security/customize';
    var data = $form.serializeObject();
    handleStoreCookieSecurity($this, action, data);
  });
  $('body').on('click', '.js-show-cookie-customize-settings', function (e) {
    e.preventDefault();
    var path = '/cookie-security/customize-modal';
    handleBasicModal(path, cookieInformationLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end gap-12\">\n                    <button type=\"button\" class=\"js-store-customize-cookies btn btn-transparent font-14 text-gray-500\">".concat(confirmMyChoicesLang, "</button>\n                    <button type=\"button\" class=\"js-accept-all-cookies btn btn-primary font-14\">").concat(acceptAllLang, "</button>\n                </div>");
      $footer.html(footerHtml);
      handleAccordionCollapse();
    }, '', '48rem');
  });
})(jQuery);
/******/ })()
;